/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.core.ShellExecutable;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ExecutableUtil;
import com.aptana.core.util.IProcessRunner;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessRunnable;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.ProcessUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.VersionUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.Messages;
import com.aptana.git.core.model.PortableGit;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitExecutable {
    private static final String GIT_SSH = "GIT_SSH";
    private static final String SSH_ASKPASS = "SSH_ASKPASS";
    private static final String GIT_ASKPASS = "GIT_ASKPASS";
    private static final String GIT_VERSION_PREFIX = "git version ";
    private static final Pattern GIT_VERSION_PATTERN = Pattern.compile("\\d+(\\.\\d+(\\.\\d+(\\.[a-zA-z\\d\\-_]+)?)?)?");
    public static final String MIN_GIT_VERSION = "1.6.0";
    private static final String GIT_EXECUTABLE = "git";
    protected static final String GIT_EXECUTABLE_WIN32 = "git.exe";
    private static final Pattern CLONE_PERCENT_PATTERN = Pattern.compile("^Receiving objects:\\s+(\\d+)%\\s\\((\\d+)/(\\d+)\\).+");
    private static List<IPath> fgLocations;
    private IPath gitPath;
    static GitExecutable fgExecutable;
    private static boolean fgAddedPrefListener;

    protected GitExecutable(IPath gitPath) {
        this.gitPath = gitPath;
    }

    public static synchronized GitExecutable instance() {
        if (fgExecutable == null) {
            fgExecutable = GitExecutable.find();
            if (!fgAddedPrefListener) {
                InstanceScope.INSTANCE.getNode(GitPlugin.getPluginId()).addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

                    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                        String pathString;
                        if (!event.getKey().equals("git_executable_path")) {
                            return;
                        }
                        fgExecutable = null;
                        if ("win32".equals(Platform.getOS()) && (pathString = (String)event.getNewValue()) != null) {
                            IPath path = Path.fromOSString((String)pathString);
                            if (path.toFile().isFile()) {
                                path = path.removeLastSegments(1);
                            }
                            if (path.toFile().isDirectory()) {
                                ShellExecutable.setPreferenceShellPath((IPath)path);
                            }
                        }
                    }
                });
                fgAddedPrefListener = true;
            }
        }
        return fgExecutable;
    }

    private static IPath getPreferenceGitPath() {
        String pref = InstanceScope.INSTANCE.getNode("com.aptana.git.core").get("git_executable_path", null);
        if (!StringUtil.isEmpty((String)pref)) {
            IPath path = Path.fromOSString((String)pref);
            if (path.toFile().isDirectory()) {
                boolean isWin32 = "win32".equals(Platform.getOS());
                path = path.append(isWin32 ? GIT_EXECUTABLE_WIN32 : GIT_EXECUTABLE);
            }
            if (GitExecutable.acceptBinary(path)) {
                return path;
            }
            IdeLog.logWarning((Plugin)GitPlugin.getDefault(), (String)MessageFormat.format("You entered a custom git path in the Preferences pane, but this path is not a valid git v{0} or higher binary. We're going to use the default search paths instead", MIN_GIT_VERSION), (String)"com.aptana.git.core/debug");
        }
        return null;
    }

    public static void setPreferenceGitPath(IPath path) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.git.core");
        if (path != null) {
            prefs.put("git_executable_path", path.toOSString());
        } else {
            prefs.remove("git_executable_path");
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (String)"Saving preferences failed.", (Throwable)e, (String)"com.aptana.git.core/debug");
        }
        fgExecutable = null;
        if ("win32".equals(Platform.getOS())) {
            if (path != null && path.toFile().isFile()) {
                path = path.removeLastSegments(1);
            }
            ShellExecutable.setPreferenceShellPath((IPath)path);
        }
    }

    private static GitExecutable find() {
        IPath prefPath = GitExecutable.getPreferenceGitPath();
        if (prefPath != null) {
            PortableGit.checkInstallation(prefPath);
            return new GitExecutable(prefPath);
        }
        boolean isWin32 = "win32".equals(Platform.getOS());
        IPath path = ExecutableUtil.find((String)(isWin32 ? GIT_EXECUTABLE_WIN32 : GIT_EXECUTABLE), (boolean)false, GitExecutable.searchLocations(), (FileFilter)new FileFilter(){

            public boolean accept(File pathname) {
                return GitExecutable.acceptBinary(Path.fromOSString((String)pathname.getAbsolutePath()));
            }
        });
        if (path != null) {
            return new GitExecutable(path);
        }
        path = PortableGit.getLocation();
        if (path != null) {
            GitExecutable.setPreferenceGitPath(path);
            return new GitExecutable(path);
        }
        GitExecutable.log(MessageFormat.format("Could not find a git binary higher than version {0}", MIN_GIT_VERSION));
        return null;
    }

    private static void log(String string) {
        IdeLog.logInfo((Plugin)GitPlugin.getDefault(), (String)string);
    }

    private static synchronized List<IPath> searchLocations() {
        if (fgLocations == null) {
            fgLocations = Platform.getOS().equals("win32") ? CollectionsUtil.newList((Object[])new IPath[]{Path.fromOSString((String)PlatformUtil.expandEnvironmentStrings((String)"%PROGRAMW6432%\\Git\\bin")), Path.fromOSString((String)PlatformUtil.expandEnvironmentStrings((String)"%PROGRAMFILES%\\Git\\bin")), Path.fromOSString((String)PlatformUtil.expandEnvironmentStrings((String)"%PROGRAMFILES(X86)%\\Git\\bin")), Path.fromOSString((String)"C:\\RailsInstaller\\Git\\bin")}) : CollectionsUtil.newList((Object[])new IPath[]{Path.fromOSString((String)"/opt/local/bin"), Path.fromOSString((String)"/sw/bin"), Path.fromOSString((String)"/opt/git/bin"), Path.fromOSString((String)"/usr/local/bin"), Path.fromOSString((String)"/usr/local/git/bin"), Path.fromOSString((String)PlatformUtil.expandEnvironmentStrings((String)"~/bin"))});
        }
        return fgLocations;
    }

    private static String versionForPath(IPath path) {
        if (path == null) {
            return null;
        }
        if (!path.toFile().isFile()) {
            return null;
        }
        String version = ProcessUtil.outputForCommand((String)path.toOSString(), null, (String[])new String[]{"--version"});
        if (version != null && version.startsWith(GIT_VERSION_PREFIX)) {
            Matcher m;
            if ((version = version.substring(GIT_VERSION_PREFIX.length())).contains("msysgit.") && StringUtil.characterInstanceCount((String)(version = version.replace("msysgit.", "msysgit_")), (char)'.') > 3) {
                version = version.replace(".msysgit", "_msysgit");
            }
            if ((m = GIT_VERSION_PATTERN.matcher(version)).find()) {
                return m.group();
            }
            return version;
        }
        return null;
    }

    public static boolean acceptBinary(IPath path) {
        if (path == null) {
            return false;
        }
        String version = GitExecutable.versionForPath(path);
        if (version == null) {
            return false;
        }
        int c = version.compareTo(MIN_GIT_VERSION);
        if (c >= 0) {
            return true;
        }
        GitExecutable.log(MessageFormat.format("Found a git binary at {0}, but is only version {1}", path, version));
        return false;
    }

    public IPath path() {
        return this.gitPath;
    }

    public IStatus runInBackground(IPath workingDir, String ... args) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.add(0, this.gitPath.toOSString());
        return new ProcessRunner().runInBackground(workingDir, arguments.toArray(new String[arguments.size()]));
    }

    protected IStatus runInBackground(IPath workingDir, Map<String, String> env, String ... args) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.add(0, this.gitPath.toOSString());
        return new ProcessRunner().runInBackground(workingDir, env, arguments.toArray(new String[arguments.size()]));
    }

    IStatus runInBackground(String input, IPath workingDirectory, String ... args) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.add(0, this.gitPath.toOSString());
        return new ProcessRunner().runInBackground(workingDirectory, null, input, arguments);
    }

    Process run(IPath directory, String ... arguments) throws IOException, CoreException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(arguments));
        args.add(0, this.gitPath.toOSString());
        return new ProcessRunner().run(directory, args.toArray(new String[args.size()]));
    }

    public static Map<String, String> getEnvironment() {
        IPath git_askpass;
        IPath ssh_askpass;
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(ShellExecutable.getEnvironment());
        IPath git_ssh = GitPlugin.getDefault().getGIT_SSH();
        if (git_ssh != null) {
            env.put(GIT_SSH, git_ssh.toOSString());
        }
        if ((ssh_askpass = GitPlugin.getDefault().getSSH_ASKPASS()) != null) {
            env.put(SSH_ASKPASS, ssh_askpass.toOSString());
        }
        if ((git_askpass = GitPlugin.getDefault().getGIT_ASKPASS()) != null) {
            env.put(GIT_ASKPASS, git_askpass.toOSString());
        }
        if ("win32".equals(Platform.getOS())) {
            env.remove("PATH");
            env.remove("PWD");
            String path = System.getenv("Path");
            env.put("Path", String.valueOf(GitExecutable.instance().path().removeLastSegments(1).toOSString()) + File.pathSeparator + path);
        }
        return GitExecutable.filterOutVariables(env);
    }

    private static Map<String, String> filterOutVariables(Map<String, String> env) {
        Iterator<Map.Entry<String, String>> i = env.entrySet().iterator();
        while (i.hasNext()) {
            String value = i.next().getValue();
            if (!value.contains("${")) continue;
            i.remove();
        }
        return env;
    }

    public Version version() {
        String versionString = GitExecutable.versionForPath(this.gitPath);
        try {
            return VersionUtil.parseVersion((String)versionString);
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (String)MessageFormat.format(Messages.GitExecutable_UnableToParseGitVersion, versionString), (Throwable)ex, (String)"com.aptana.git.core/debug");
            return Version.emptyVersion;
        }
    }

    public IStatus clone(String sourceURI, IPath dest, boolean shallow, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        try {
            Version version = this.version();
            boolean includeProgress = version.compareTo(new Version(1, 7, 0)) >= 0;
            Map<String, String> env = GitExecutable.getEnvironment();
            ArrayList<String> args = new ArrayList<String>();
            args.add("clone");
            if (shallow) {
                args.add("--depth");
                args.add("1");
            }
            if (includeProgress) {
                args.add("--progress");
            }
            args.add("--");
            args.add(sourceURI);
            args.add(dest.toOSString());
            Process p = this.run(env, args.toArray(new String[args.size()]));
            if (p == null) {
                Status status = new Status(4, GitPlugin.getPluginId(), MessageFormat.format(Messages.GitExecutable_UnableToLaunchCloneError, sourceURI, dest));
                return status;
            }
            subMonitor.worked(100);
            CloneRunnable runnable = new CloneRunnable(p, (IProgressMonitor)subMonitor.newChild(900));
            Thread t = new Thread((Runnable)((Object)runnable));
            t.start();
            t.join();
            IStatus iStatus = runnable.getResult();
            return iStatus;
        }
        catch (CoreException e) {
            IdeLog.log((Plugin)GitPlugin.getDefault(), (IStatus)e.getStatus());
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)GitPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            Status status = new Status(4, GitPlugin.getPluginId(), e.getMessage(), e);
            return status;
        }
        finally {
            subMonitor.done();
        }
    }

    protected Process run(Map<String, String> env, String ... args) throws IOException, CoreException {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.add(0, this.path().toOSString());
        return this.createProcessRunner().run(null, env, arguments.toArray(new String[arguments.size()]));
    }

    protected IProcessRunner createProcessRunner() {
        return new ProcessRunner();
    }

    static class CloneRunnable
    extends ProcessRunnable {
        private int lastPercent;

        CloneRunnable(Process p, IProgressMonitor monitor) {
            super(p, monitor, false);
        }

        protected void handleLine(String line) {
            String percent;
            int percentInt;
            super.handleLine(line);
            Matcher m = CLONE_PERCENT_PATTERN.matcher(line);
            if (m.find() && (percentInt = Integer.parseInt(percent = m.group(1))) > this.lastPercent) {
                this.monitor.worked(percentInt - this.lastPercent);
                this.lastPercent = percentInt;
            }
        }

        public void run() {
            this.lastPercent = 0;
            super.run();
        }
    }
}

